/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.grizzly.attributes;

import org.glassfish.grizzly.attributes.AttributeBuilder;
import org.glassfish.grizzly.attributes.AttributeHolder;
import org.glassfish.grizzly.attributes.AttributeStorage;
import org.glassfish.grizzly.attributes.IndexedAttributeAccessor;
import org.glassfish.grizzly.utils.NullaryFunction;

public final class Attribute<T> {
    private final AttributeBuilder builder;
    private final String name;
    private final NullaryFunction<T> initializer;
    private final T defaultValue;
    private final int attributeIndex;

    public String toString() {
        return "Attribute[" + this.name + ':' + this.attributeIndex + ']';
    }

    protected Attribute(AttributeBuilder builder, String name, int index2, T defaultValue2) {
        this.builder = builder;
        this.name = name;
        this.attributeIndex = index2;
        this.initializer = null;
        this.defaultValue = defaultValue2;
    }

    protected Attribute(AttributeBuilder builder, String name, int index2, NullaryFunction<T> initializer) {
        this.builder = builder;
        this.name = name;
        this.attributeIndex = index2;
        this.initializer = initializer;
        this.defaultValue = null;
    }

    public T peek(AttributeHolder attributeHolder) {
        return this.weakGet(attributeHolder);
    }

    public T peek(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.peek(holder);
        }
        return null;
    }

    public T get(AttributeHolder attributeHolder) {
        T result2 = this.weakGet(attributeHolder);
        if (result2 == null && (result2 = this.initializer != null ? this.initializer.evaluate() : this.defaultValue) != null) {
            this.set(attributeHolder, result2);
        }
        return result2;
    }

    public T get(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.get(holder);
        }
        T result2 = this.initializer != null ? this.initializer.evaluate() : this.defaultValue;
        if (result2 != null) {
            this.set(storage, result2);
        }
        return result2;
    }

    public void set(AttributeHolder attributeHolder, T value2) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        if (indexedAccessor != null) {
            indexedAccessor.setAttribute(this.attributeIndex, value2);
        } else {
            attributeHolder.setAttribute(this.name, value2);
        }
    }

    public void set(AttributeStorage storage, T value2) {
        this.set(storage.getAttributes(), value2);
    }

    public T remove(AttributeHolder attributeHolder) {
        T result2 = this.weakGet(attributeHolder);
        if (result2 != null) {
            this.set(attributeHolder, null);
        }
        return result2;
    }

    public T remove(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.remove(holder);
        }
        return null;
    }

    public boolean isSet(AttributeHolder attributeHolder) {
        return this.weakGet(attributeHolder) != null;
    }

    public boolean isSet(AttributeStorage storage) {
        AttributeHolder holder = storage.getAttributes();
        if (holder != null) {
            return this.isSet(holder);
        }
        return false;
    }

    public String name() {
        return this.name;
    }

    public int index() {
        return this.attributeIndex;
    }

    private T weakGet(AttributeHolder attributeHolder) {
        IndexedAttributeAccessor indexedAccessor = attributeHolder.getIndexedAttributeAccessor();
        Object result2 = indexedAccessor != null ? indexedAccessor.getAttribute(this.attributeIndex) : attributeHolder.getAttribute(this.name);
        return (T)result2;
    }
}

